#ifndef _PLATFORMLAYERLINUX_H_
#define _PLATFORMLAYERLINUX_H_

using namespace std;
#include <map>
#include "PlatformLayer.h"
#include <usb.h>

typedef struct _itemDsc{
    char * port;
    int qtyep;
    int fd;
    unsigned char stdDeviceDsc[USB_DT_DEVICE_SIZE];
    unsigned char strManufacturer[255];
    unsigned char strProduct[255];
    unsigned char strSerialNumber[255];
    unsigned char stdConfigurationDsc[USB_DT_CONFIG_SIZE];
    unsigned char stdInterfaceDsc[USB_DT_INTERFACE_SIZE];
    unsigned char stdEndpointDsc[15][USB_DT_ENDPOINT_SIZE];
} itemDsc;

class platformLayerLinux : public platformLayer {

    private:
        map<int,itemDsc> descriptors;
        void findDevices(void);
    public:
        platformLayerLinux();
        ~platformLayerLinux();
        map<int,itemDsc> getDescriptors();
};

#endif
